/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "GetInputDevicesCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"
#include "RendererList.h"
#include "InputManager.h"


ExecutionResult GetInputDevicesCommand::execute(ICommandExecutor* executor)
{
    ExecutionResult result = ExecutionSuccess;

    RendererList* rList;
    RendererListConstIterator it;

    rList = executor->getRendererList();
	for (it = rList->begin(); (it != rList->end()) && (result == ExecutionSuccess); it++)
	{
		result = (*it)->getSupportedSeats(m_bitmask, m_pSeatArray, m_pSizeSeatArray)? ExecutionSuccess : ExecutionFailed;
	}

    return result;
}

const std::string GetInputDevicesCommand::getString()
{
    std::stringstream description;
    description << "GetInputDevicesCommand("
                << "bitmask=" << m_bitmask
                << ")";
    return description.str();
}
